function plot_cepstral_liftering(graphicPanel1,titleBox1,stitle,fs,nfft,BNmag,cell_lifter);

% define colors for curve plotting
    colors=['b','g','r','c','m','k'];
    
	set(titleBox1,'String',stitle);
    set(titleBox1,'FontSize',15);
    
    reset(graphicPanel1);
    axes(graphicPanel1);
    cla;

    plot(0:fs/nfft:fs/2,BNmag(1:nfft/2+1),'k-','LineWidth',1);
    xpp=['Frequency (Hz); fs=',num2str(fs),' samples/second'];
	xlabel(xpp),ylabel('Log Magnitude'),grid on,  hold on;

    for lifterl=20:20:100
        BNmag=cell_lifter{lifterl/20};
        plot(0:fs/nfft:fs/2,BNmag(1:nfft/2+1),colors(lifterl/20),...
            'LineWidth',2);
    end   
    legend('lifter:none','lifter:20','lifter:40','lifter:60',...
        'lifter:80','lifter:100');
end